# Script Version: 3.0.0.8
# Script Name: app-b-acd-aa-3.0.0.8.tcl
#
# Copyright (c) 2012 by Cisco Systems, Inc.
# All rights reserved.
#-----------------------------------------------------------
# Modification History:
# Modified by: Ashish Elizabeth
# Modified Date: November 2019
# - Fix for CSCvs19170
# - Fix commented to play all agent busy prompt in the function proc act_GotDestNoOption() which was playing all agent busy after the
# welcome prompt even though the phones are free.
# Also fixed the ringback issue where caller was not able to get ringback from phones.
#
# Modified by: Raghavendra GV
# Modified Date: Jan 28 2019
#  - Subtract Prompt play time from answer, abandon Time when number-of-hunt-grps is 1 for BE4K.
#  - Added redirectCount when call redirecting to voice-mail for BE4K
#
# Modified by: Raghavendra GV
# Modified Date: Aug 24 2018
#  - Fix for CSCty10940
#  - Fix: Added commandHandle global param in act_ExitQueue proc
# Modified Date: Sep 05 2018
#  - Fix for CSCvm33529
#  - Introduced new parameter voice-mail-handoff to switch between leg setup and
#    handoff commands when placing call to voice mail number
#
# Modifed by: Veena Kumarareddy
# Modifed Date: May  24, 2017
# - Fix for CSCvd89159
#
# - Fix commenting media play command  since we are stopping the audio immediately
#
# Modified by: Yawming Chen
# Jan 31 2012
# 1.Fix exit to voice mail issue
#   root cause - collecting digit command for exit queue option is not terminated
# 2.add "set callInfo(displayInfo) [infotag get leg_display_info leg_incoming]"
#   to keep original dispplayinfo when using -l option on leg setup
#
# Sep 9 2010
# Add feature for playing queue position
#
# Modified by: Yawming Chen
# Modified Date: July 15 2009
# - added detecting if it is MLPP image for latest IOS, also modified for MLPP precedence flipping.
# - also introduced new parameter menu-option-timeout
# - if it's configured it will override PARAM(initialDigitTimeout)
# - also changed menu-timeout range from 0 to 10, it was 1 to 10
# - 0 means no repeat for option prompt
#
# Modified by: Vijay Prasad
# Modified Date: April 30,2009
# - Fix for CSCsz20368
#
# - Fix: cleanup the queue immediately when caller press exitQ option
#
# Modified by: Yawming Chen
# Modified Date: Jan 23, 2009
# - Fix: changed SECOND_GREEETING_TIMER to SECOND_GREETING_TIMER in start timer
# - Fix: added stop KEEP_ALIVE_TIMER in act_ExitQueue
#
#
# Modified by: Yawming Chen
# Modified Date: Sep 24, 2008
# - added support for MLPP queuing
# - added support for exit queue
# - added support for extension overflow
#
# Modified by: Jasmine Kalaiselvan
# Modified Date: April 10, 2008
# - Added support for BACD working over SIP trunk
# - Incorporated fix for CSCsj67507
# - Incorporated fix for CSCsl54693
# - Incorporated fix for CSCso70767
#
# Modified by: Satish Ananthanarayana
# Modified Date: June 14, 2006
# - Increased initialDigitTimeout to 20 seconds as per
# - SR 603748939
#
# Modified by: Satish Ananthanarayana
# Modified Date: June 02, 2006
# - Removed leg setupack leg_incoming in the act_ISN_Invocation
# - procedure
# - Incorporated fix for CSCsd14220
# - Incorporated fix for CSCsd14234
#
# Modified by: Satish Ananthanarayana
# Modified Date: May 10, 2006
# - Introduced new parameter menu-timeout to connect the user
#   to an operator after this timeout, ie., if user did not
#   select any option even after playing the main menu multiple
#   times = menu-timeout, call will be connected to the operator.
#   A new prompt _bacd_xferto_operator.au has been added. This prompt
#   plays before the call is connected to the operator
# - Incorporated fix for CSCsd18856
# - Incorporated fix for CSCeh53421
#
# Modified by: Satish Ananthanarayana
# Modified Date: April 06, 2005
# - Added support to interoperate with ISN Application
# - Incorporated CSCeh53421 fix
#
# Modifed by: Satish Ananthanarayana
# Modified Date: Feb 10, 2005
# - Removed RNA timeout in the script
# - Added support for drop through mode
# - changed the range for call-retry-timer from 5-30 to 1-30
# - changed the default value of call-retry-timer to 5 sec
# - Added handoff string during handoff to call queue
# - Added support for MOH livefeed
#
#-----------------------------------------------------------
#
# Cisco CME B-ACD Auto Attendant Application
#
#

proc init { } {
	global PARAM
	global PARAM1
	global PARAM2
	global callInfo

	set PARAM(interruptPrompt) true
	set PARAM(maxDigits) 1
	set PARAM(initialDigitTimeout) 20
	set PARAM(abortKey) *

	set PARAM1(interruptPrompt) true
	set PARAM1(dialPlanTerm) true
	set PARAM1(initialDigitTimeout) 20
	set PARAM1(terminationKey) #
	set PARAM1(abortKey) *

	set PARAM2(interruptPrompt) true
	set PARAM2(maxDigits) 1
	set PARAM2(initialDigitTimeout) 4
	set PARAM2(abortKey) *

	set callInfo(setupFromBACD) true
}


proc init_ConfigVars { } {
	global PARAM
	global destination
	global aaPilot
	global aaPilot2
	global CLI
	global serviceName
	global hString
	global voiceMailDN
	global vmHandoff
	global welcomePrompt
	global dropThroPrompt
	global dropThroOption
	global dialByExtension
	global configFail
	global dropThroMode
	global optionIndex
	global maxExtensionLen
	global isnName
	global methodList
	global queueExitOption1
	global queueExitOption2
	global queueExitOption3
	global queueExitExtension1
	global queueExitExtension2
	global queueExitExtension3
	global queueOverflowExtension
	#MLPP image flag
	global isMLPPcode
	# check MLPP image

	catch {infotag get leg_precedence_info 1234} result
	puts ">>>>>>>> result = $result <<<<<<<<<"
	if {[regexp "Unrecognized.*VAR_TAG" $result] || [regexp "Illegal Info Tag" $result] } {
	    set isMLPPcode 0
	    # is not MLPP image
	} else {
	    puts "TCL AA: -- is a MLPP image --\n"
	    set isMLPPcode 1
	    # is MLPP image
	}

	# aa-pilot is the IVR number configured on the gateway to be used by the customer
	set configFail 0
	if [infotag get cfg_avpair_exists menu-option-timeout] {
		set PARAM(initialDigitTimeout) [string trim [infotag get cfg_avpair menu-option-timeout]]
	}

	if [infotag get cfg_avpair_exists aa-pilot] {
		set aaPilot [string trim [infotag get cfg_avpair aa-pilot]]

	} else {
		set aaPilot "NONE"
		puts -nonewline "TCL AA: -- ERROR: Mandatory parameter aa-pilot does not exist --"
		set configFail 1
		call close
	}

	if [infotag get cfg_avpair_exists aa-pilot2] {
		set aaPilot2 [string trim [infotag get cfg_avpair aa-pilot2]]
	} else {
		set aaPilot2 "NONE"
		puts -nonewline "TCL AA: -- Warning: Mandatory parameter aa-pilot2 does not exist --\n"
		puts -nonewline "TCL AA: -- Warning: If you are using 2nd pilot number call will fail --"
	}

	if [infotag get cfg_avpair_exists service-name] {
		set serviceName [string trim [infotag get cfg_avpair service-name]]
	} else {
		set serviceName "NONE"
		puts -nonewline "TCL AA: -- ERROR: Mandatory parameter service-name does not exist --"
		set configFail 1
		call close
	}
	if [infotag get cfg_avpair_exists isn-name] {
		set isnName [string trim [infotag get cfg_avpair isn-name]]
		puts -nonewline "TCL AA: --  ISN Application is configured --"
	} else {
		set isnName "NONE"
	}
    	if [infotag get cfg_avpair_exists send-account] {
       		 set methodList [string trim [infotag get cfg_avpair send-account]]
		 puts -nonewline "TCL AA: -- Accouting param configured"
        } else {
   	         set methodList "NONE"
    	}
	if [infotag get cfg_avpair_exists handoff-string] {
		set hString [string trim [infotag get cfg_avpair handoff-string]]
	} else {
		set hString "NONE"
		puts -nonewline "TCL AA: -- ERROR: Mandatory parameter handoff-string does not exist --"
		set configFail 1
		call close
	}
	if [infotag get cfg_avpair_exists voice-mail] {
		set voiceMailDN [string trim [infotag get cfg_avpair voice-mail]]
	} else {
		set voiceMailDN "NONE"
		puts -nonewline "TCL AA: -- ERROR: Mandatory parameter voice-mail does not exist --"
		set configFail 1
		call close
	}
	if [infotag get cfg_avpair_exists voice-mail-handoff] {
		set vmHandoff [string trim [infotag get cfg_avpair voice-mail-handoff]]
		if { ![string is boolean -strict $vmHandoff] } {
		   set vmHandoff true
		}
		puts -nonewline "TCL AA: -- Handoff to Voice mail param set to $vmHandoff"
	} else {
		set vmHandoff true
	}
	if [infotag get cfg_avpair_exists welcome-prompt] {
		set welcomePrompt [string trim [infotag get cfg_avpair welcome-prompt]]
	} else {
		set welcomePrompt "_bacd_welcome.au"
	}
	if [infotag get cfg_avpair_exists drop-through-prompt] {
		set dropThroPrompt [string trim [infotag get cfg_avpair drop-through-prompt]]
	} else {
		set dropThroPrompt "NONE"
	}
	if [infotag get cfg_avpair_exists drop-through-option] {
		set dropThroOption [string trim [infotag get cfg_avpair drop-through-option]]
                if {$dropThroOption == 0} {
                  puts -nonewline "TCL AA: -- ERROR: drop-through-option should be more than 0"
                  set configFail 1
                  call close
		}
		set dropThroMode 1
	} else {
		set dropThroOption "NONE"
		set dropThroMode 0
	}
	if [infotag get cfg_avpair_exists dial-by-extension-option] {
		set dialByExtension [string trim [infotag get cfg_avpair dial-by-extension-option]]
	} else {
		set dialByExtension "NONE"
	}
	if [infotag get cfg_avpair_exists queue-exit-option1] {
		set queueExitOption1 [string trim [infotag get cfg_avpair queue-exit-option1]]
	} else {
		set queueExitOption1 "NONE"
	}
	if [infotag get cfg_avpair_exists queue-exit-extension1] {
		set queueExitExtension1 [string trim [infotag get cfg_avpair queue-exit-extension1]]
	} else {
		set queueExitExtension1 "NONE"
	}
	if [infotag get cfg_avpair_exists queue-exit-option2] {
		set queueExitOption2 [string trim [infotag get cfg_avpair queue-exit-option2]]
	} else {
		set queueExitOption2 "NONE"
	}
	if [infotag get cfg_avpair_exists queue-exit-extension2] {
		set queueExitExtension2 [string trim [infotag get cfg_avpair queue-exit-extension2]]
	} else {
		set queueExitExtension2 "NONE"
	}
	if [infotag get cfg_avpair_exists queue-exit-option3] {
		set queueExitOption3 [string trim [infotag get cfg_avpair queue-exit-option3]]
	} else {
		set queueExitOption3 "NONE"
	}
	if [infotag get cfg_avpair_exists queue-exit-extension3] {
		set queueExitExtension3 [string trim [infotag get cfg_avpair queue-exit-extension3]]
	} else {
		set queueExitExtension3 "NONE"
	}
	if [infotag get cfg_avpair_exists queue-overflow-extension] {
		set queueOverflowExtension [string trim [infotag get cfg_avpair queue-overflow-extension]]
	} else {
		set queueOverflowExtension "NONE"
	}
	if [infotag get cfg_avpair_exists max-extension-length] {
		set maxExtensionLen [string trim [infotag get cfg_avpair max-extension-length]]
		if { $maxExtensionLen < 0 } {
			puts -nonewline "TCL AA: -- ERROR: max-extension-length $maxExtensionLen is invalid --"
			set configFail 1
			call close
		}
	} else {
		set maxExtensionLen 5
		puts -nonewline "TCL AA: -- max-extension-length is set to default value of $maxExtensionLen --"
	}
	if [infotag get cfg_avpair_exists option-index] {
		set optionIndex [string trim [infotag get cfg_avpair option-index]]
	} else {
		set optionIndex 0
	}

	# CLI: second-greeting-time (5 - 120) default 30
	set result [init_cfgAvPair second-greeting-time 30 5 120]
	switch $result {
		{invalid type} {
			puts -nonewline "TCL AA: -- ERROR: Mandatory parameter second-greeting-time $result --"
			set configFail 1
			call close
		}
		{does not exist} {
			puts -nonewline "TCL AA: -- Mandatory parameter second-greeting-time $result --"
			puts -nonewline "TCL AA: -- Setting default to 30"
			set CLI(second-greeting-time) 30
		}
		default {
			puts -nonewline "TCL AA: -- Valid mandatory parameter second-greeting-time = $CLI(second-greeting-time) --"
		}
	}

	# CLI: call-retry-timer (1 - 30) default 5
	set result [init_cfgAvPair call-retry-timer 5 1 30]
	switch $result {
		{invalid type} {
			puts -nonewline "TCL AA: -- ERROR: Mandatory parameter call-retry-timer $result --"
			set configFail 1
			call close
		}
		{does not exist} {
			puts -nonewline "TCL AA: -- Mandatory parameter call-retry-timer $result --"
			puts -nonewline "TCL AA: -- Setting default to 5"
			set CLI(call-retry-timer) 5
		}
		default {
			puts -nonewline "TCL AA: -- Valid mandatory parameter call-retry-timer\
				= $CLI(call-retry-timer)  --"
		}
	}

	# CLI: max-time-call-retry (30 - 3600) default 600
	set result [init_cfgAvPair max-time-call-retry 600 30 3600]
	switch $result {
		{invalid type} {
			puts -nonewline "TCL AA: -- ERROR: Mandatory parameter max-time-call-retry $result --"
			set configFail 1
			call close
		}
		{does not exist} {
			puts -nonewline "TCL AA: -- Mandatory parameter max-time-call-retry $result --"
			puts -nonewline "TCL AA: -- Setting default to 600"
			set CLI(max-time-call-retry) 600
		}
		default {
			puts -nonewline "TCL AA: -- Valid mandatory parameter max-time-call-retry = $CLI(max-time-call-retry)  --"
		}
	}

	# CLI: max-time-vm-retry (1 - 3) default 1
	set result [init_cfgAvPair max-time-vm-retry 1 1 3]
	switch $result {
		{invalid type} {
			puts -nonewline "TCL AA: -- ERROR: Mandatory parameter max-time-vm-retry $result --"
			set configFail 1
			call close
		}
		{does not exist} {
			puts -nonewline "TCL AA: -- Mandatory parameter max-time-vm-retry $result --"
			puts -nonewline "TCL AA: -- Setting default to 1"
			set CLI(max-time-vm-retry) 1
		}
		default {
			puts -nonewline "TCL AA: -- Valid mandatory parameter max-time-vm-retry = $CLI(max-time-vm-retry)  --"
		}
	}
	# CLI: number-of-hunt-grps (1 - 3) default 3
	set result [init_cfgAvPair number-of-hunt-grps 3 1 3]
	switch $result {
		{invalid type} {
			puts -nonewline "TCL AA: -- ERROR: Mandatory parameter number-of-hunt-grps $result"
			set configFail 1
			call close
		}
		{does not exist} {
			puts -nonewline "TCL AA: -- Mandatory parameter number-of-hunt-grps $result"
			puts -nonewline "TCL AA: -- Setting default to 3"
			set CLI(number-of-hunt-grps) 3
		}
		default {
			puts -nonewline "TCL AA: -- Valid Mandatory parameter number-of-hunt-grps = $CLI(number-of-hunt-grps) --"
		}
	}
	# CLI: menu-timeout (0 - 10) default 3
	set result [init_cfgAvPair menu-timeout 3 0 10]
	switch $result {
		{invalid type} {
			puts -nonewline "TCL AA: -- ERROR: Optional parameter menu-timeout $result"
			set configFail 1
			call close
		}
		{does not exist} {

			set CLI(menu-timeout) "NONE"
		}
		default {

			puts -nonewline "TCL AA: -- Valid optional parameter menu-timeout = $CLI(menu-timeout) --"
		}
	}
}

proc init_cfgAvPair {name default lower upper} {

	global CLI

	if {[infotag get cfg_avpair_exists $name]} {
		set tmpStr [string trim [infotag get cfg_avpair $name]]
		if {[regexp {^([0-9]+)$} $tmpStr d CLI($name)]} {
			if {$CLI($name) < 0} {
				puts -nonewline "TCL AA: -- ERROR: ++ $name is to a negative value ++"
				return "invalid type"
			} elseif {$CLI($name) < $lower} {
				set CLI($name) $lower
				puts -nonewline "TCL AA: ++ $name is set to less than minimum allowed value of $lower ++"
				puts -nonewline "TCL AA: ++ Setting $name to minimum value of $lower ++"
			} elseif {$CLI($name) > $upper} {
				set CLI($name) $upper
				puts -nonewline "TCL AA: ++ $name is set to more than maximum allowed value of $upper ++"
				puts -nonewline "TCL AA: ++ Setting $name to maximum value of $upper ++"
			}
		} else {
			return "invalid type"
		}
	} else {
		return "does not exist"
	}
}


proc init_perCallVars { } {
	puts "\nproc init_perCallvars"
	global ani
	global dnis
	global queueMessage
	global queueID
	global AATIMER
	global callAbandon
	global KATIMER
	global keepAliveTime
	global callCloseFlag
	global invalidHuntGrp
	global invalidExtension
	global vmStatFlag
	global vmSetupFlag
	global maxVMRetry
	global playMusicFlag
	global optionSelected
	global svcUnavlbl
	global destHunt
	global callInfo
	global answerTime
	global abandonTime
	global retryMenuFlag
	global dropThroFlag
	global liveMusicFeed
	global legDisconnectTimer
	global dropAgtFlag
	global retryDigitCollect
	global isnInvokedFlag
	global isnTimeout
	global menuRetry
	global queueExitFlag
	global scndGreCnt
	global commandHandle
	global returnCode
	global returnSetup
	global commandSetup
	# added for checking MLPP image
	global isMLPPcode

	# only used in  MLPP image
	global service_domain_index
	global mlpp_precedence_index
	global ivr_precedence_index
	#for exit Q
	global exitQ_cleanup
	set exitQ_cleanup 0
	
	global queueIdx
	set queueIdx 0
	
	# added for MLPP
	# "Service_Domain : Precedence_level : ivr_equivalent_precedence"
	set service_domain_index 0
	set mlpp_precedence_index 1
	set ivr_precedence_index 2

	set ani ""
	set dnis ""
	set callAbandon 1
	set keepAliveTime 10
	set callCloseFlag 0
	set invalidHuntGrp 0
	set invalidExtension 0
	set vmStatFlag 0
	set vmSetupFlag 0
	set maxVMRetry 0
	set playMusicFlag 0
	set optionSelected 0
	set svcUnavlbl 0
	set destHunt 0
	set answerTime 0
	set abandonTime 0
	set retryMenuFlag 0
	set dropThroFlag 0
	set liveMusicFeed 0
	set legDisconnectTimer 10
	set dropAgtFlag 0
	set retryDigitCollect 1
	set isnInvokedFlag 0
	set isnTimeout 45
	set menuRetry 0
	set queueExitFlag 0
	set scndGreCnt 0
	set commandHandle 0
	set returnCode -1
        set returnSetup 0
	set commandSetup 0

	set ani [infotag get leg_ani]
	set dnis [infotag get leg_dnis]
        regexp {[0-9]+} $dnis dnis
	set callInfo(originationNum) $ani
	set callInfo(redirectNum) ""
	set callInfo(redirectCount) 0
	set callInfo(guid) ""

}

#qp is the current position in queue
proc play_q_position {qp} {
	
	switch -exact $qp {

		0 { media play leg_incoming _bacd_allagentsbusy.au %s200 _Next_Caller.wav }
		1 { media play leg_incoming _bacd_allagentsbusy.au %s200 _1_Call_Ahead.wav }
		2 { media play leg_incoming _bacd_allagentsbusy.au %s200 _2_Calls_Ahead.wav }
		3 { media play leg_incoming _bacd_allagentsbusy.au %s200 _3_Calls_Ahead.wav }
		4 { media play leg_incoming _bacd_allagentsbusy.au %s200 _4_Calls_Ahead.wav }
		5 { media play leg_incoming _bacd_allagentsbusy.au %s200 _5_Calls_Ahead.wav }
		6 { media play leg_incoming _bacd_allagentsbusy.au %s200 _6_Calls_Ahead.wav }
		7 { media play leg_incoming _bacd_allagentsbusy.au %s200 _7_Calls_Ahead.wav }
		8 { media play leg_incoming _bacd_allagentsbusy.au %s200 _8_Calls_Ahead.wav }
  default { media play leg_incoming _bacd_allagentsbusy.au %s200 _9_Or_More_Calls_Ahead.wav }

    }
}


proc act_Handoff_Activity { } {
	set isnString [infotag get evt_handoff_string]
	if { ($isnString == "ISN") } {
		puts -nonewline "TCL AA: >>> CME B-ACD AA Application is invoked by ISN Application <<<"
		act_ISN_Invocation
	} else {
		act_Setup
	}
}


# added for MLPP

proc get_precedence_info {idx} {
# only for MLPP code
# get the valuse of "ivr_equivalent_precedence"
# "Service_Domain : Precedence_level : ivr_equivalent_precedence"

   set legID [string trim [infotag get leg_incoming]]

   if {$legID != ""} {
     	set precedence_info [infotag get leg_precedence_info $legID]
     	set return_value [lindex [split $precedence_info :] $idx]
     	puts "preced info : $precedence_info ,index : $idx ,return value: $return_value"
        return $return_value
     } else {
	    puts "TCL AA: >>>  legID = NULL <<<"
  	    return $legID

    }
}



proc act_Setup { } {
	global PARAM
	global AATIMER
	global callInfo
	global dnis
	global aaPilot
	global aaPilot2
	global queueID
	global ani
	global serviceName
	global welcomePrompt
	global callCloseFlag
	global configFail
	global CLI
	global hString
	global dropThroMode
	global dropThroPrompt
	global isnInvokedFlag
	global methodList
	global initialized
	# added for MLPP
	global ivr_precedence_index
       global isMLPPcode


	set AATIMER(curTime) [clock seconds]

	if { $initialized == 0 } {
		init_ConfigVars
		set initialized 1
	}

	if { $configFail == 0} {
		init_perCallVars
		infotag set med_language 1
		set queueID [infotag get mod_handle_service B-ACD-SERVICE]

		# added for MLPP
		if {$isMLPPcode == 1} {
			set is_mlpp [get_precedence_info $ivr_precedence_index ]
			puts "is mlpp = $is_mlpp\n"
		} else {
			set is_mlpp 0
			# 0 is the lowest precedence and is not mlpp call
			# modified for MLPP precedence level changes (0 is the lowest and 9 is the highest
		}

		if {$queueID == "unavailable"} {
			puts -nonewline "TCL AA: +++ B-ACD-SERVICE not registered, Starting B-ACD-SERVICE +++"
			if { $serviceName == "NONE" } {
				puts -nonewline "TCL AA: +++ Unable to start B-ACD-SERVICE improper application name or no application name configured +++"
				call close
			} else {
				handoff appl leg_incoming $serviceName -s $hString
				call close
			}
		} elseif { ($dnis == "") || ($dnis == $aaPilot) || ($dnis == $aaPilot2) || ($is_mlpp >= 0 && $is_mlpp <= 9) } {
			if { $isnInvokedFlag == 0 } {
			   # leg setupack leg_incoming
			   # leg proceeding leg_incoming
			   # leg connect leg_incoming
               		   # above 3 lines were original, modified to the following to check leg state
			   # modified per Vijay Kannan's request
			   set legID [string trim [infotag get leg_incoming]]
			   set legState [infotag get leg_state $legID]
			   #check leg state before do "leg connect
			   #to make sure leg is not connected already
			   if {$legState != "lg_005" && $legState != "lg_008"} {
			       if {$legState == "lg_001"} {
			           puts "\n>>>>>>>>>legstate = lg_001<<<<<<<<<<<\n"
			           leg setupack leg_incoming
			           leg proceeding leg_incoming
			           leg connect leg_incoming
			       } elseif {$legState == "lg_002"} {
			            puts "\n>>>>>>>>>legstate = lg_002<<<<<<<<<<<\n"
			           leg proceeding leg_incoming
			           leg connect leg_incoming
			       } else {
			            puts "\n>>>>>>>>>legstate = $legState<<<<<<<<<<<\n"
			            leg connect leg_incoming
			       }
			   }
			   # end of modification
			   # lg_001 --> LEG_INCOMING_FIRST
			   # lg_002 --> LEG_INCACKED
			   # lg_003 --> LEG_INCPROCEED
			   # lg_005 --> LEG_INCCONNECTED
			   # lg_008 --> LEG_OUTPROCEED

				set callInfo(guid) [infotag get leg_incoming_guid]
				if {$methodList != "NONE" } {
					set aaaList(h323-ivr-out) "GUID: $callInfo(guid) ; BACD-AA-Call ; AA Name: $hString ; Pilot No: $aaPilot"
					aaa accounting update leg_incoming -a aaaList -s $methodList
				}
			}
			if { ($CLI(number-of-hunt-grps) == 1) && ($dropThroMode == 1)} {
				if {$dropThroPrompt == "NONE"} {
					act_GotDestNoOption
				} else {
					media play leg_incoming $dropThroPrompt
					puts -nonewline "TCL AA: ++ Playing Drop Through Prompt ++"
					fsm setstate OPTIONSELECTED
				}
			} else {
				leg collectdigits leg_incoming PARAM
				puts -nonewline "TCL AA: ++ Playing Welcome Prompt and options menu ++"
				media play leg_incoming $welcomePrompt %s500 _bacd_options_menu.au
				fsm setstate GETDEST
			}
		} else {
			call close
		}
	} else {
		call close
	}
}

proc act_ISN_Invocation { } {
	global PARAM
	global AATIMER
	global callInfo
	global dnis
	global aaPilot
	global queueID
	global ani
	global serviceName
	global welcomePrompt
	global callCloseFlag
	global configFail
	global CLI
	global hString
	global methodList
	global dropThroMode
	global dropThroPrompt
	global isnInvokedFlag
        global initialized

	set AATIMER(curTime) [clock seconds]

        if { $initialized == 0 } {
             init_ConfigVars
             set initialized 1
        }

	if { $configFail == 0} {
		init_perCallVars
		infotag set med_language 1
		# set isnInvokedFlag 1
              	set callInfo(guid) [infotag get leg_incoming_guid]
		if {$methodList != "NONE" } {
			set aaaList(h323-ivr-out) "GUID: $callInfo(guid) ; BACD-AA-Call ; AA Name: $hString ; ISN Call"
                        aaa accounting update leg_incoming -a aaaList -s $methodList
                }
		set queueID [infotag get mod_handle_service B-ACD-SERVICE]
		if {$queueID == "unavailable"} {
			puts -nonewline "TCL AA: +++ B-ACD-SERVICE not registered, Starting B-ACD-SERVICE +++"
			if { $serviceName == "NONE" } {
				puts -nonewline "TCL AA: +++ Unable to start B-ACD-SERVICE,improper application name or no application name configured +++"
				call close
			} else {
				handoff appl leg_all $serviceName -s "$hString ISN"
				call close
			}
		} else {
			set callInfo(guid) [infotag get leg_incoming_guid]
			if { ($CLI(number-of-hunt-grps) == 1) && ($dropThroMode == 1)} {
				if {$dropThroPrompt == "NONE"} {
					act_GotDestNoOption
				} else {
					media play leg_incoming $dropThroPrompt
					puts -nonewline "TCL AA: ++ Playing Drop Through Prompt ++"
					fsm setstate OPTIONSELECTED
				}
			} else {
				leg collectdigits leg_incoming PARAM
				puts -nonewline "TCL AA: ++ Playing Welcome Prompt and options menu ++"
				media play leg_incoming $welcomePrompt %s500 _bacd_options_menu.au
				fsm setstate GETDEST
			}
		}
	} else {
		call close
	}
}

proc act_GotDestNoOption { } {
	global optionSelected
	global queueMessage
	global queueID
	global keepAliveTime
	global KATIMER
	global AATIMER
	global CLI
	global playMusicFlag
	global callCloseFlag
	global svcUnavlbl
	global dropThroOption
	global dropThroMode
	global optionIndex
	global retryDigitCollect
	global retryMenuFlag
	global isMLPPcode
	# added for MLPP
	global ivr_precedence_index

	set playMusicFlag 1
	set retryDigitCollect 0
	if { $CLI(number-of-hunt-grps) == 1 } {
		set AATIMER(curTime) [clock seconds]
	}
	set KATIMER(keepTime) [clock seconds]
	if {$dropThroMode == 1} {
		set optionSelected [expr $optionIndex + $dropThroOption]
	} else {
		# NULL for Operator
		set optionSelected NULL
	}
	set queueMessage(optionIDX) $optionSelected
	set queueMessage(callState) CALL_NEW
	set queueMessage(keepTime) $KATIMER(keepTime)

	# added for MLPP
	if {$isMLPPcode == 1} {
		set queueMessage(Precedence) [get_precedence_info $ivr_precedence_index]
	}
	# added for MLPP

	set rval [sendmsg $queueID -p queueMessage]
	if { $rval == "unavailable" } {
		media play leg_incoming _bacd_disconnect.au
		set callCloseFlag 1
		set svcUnavlbl 1
	} else {
		if {$dropThroMode == 0} {
			set retryMenuFlag 0
			set liveMusicFeed 1

			media play leg_incoming moh:livemoh
			timer start named_timer $CLI(second-greeting-time) SECOND_GREETING_TIMER
		} else {
			set retryMenuFlag 0
			set liveMusicFeed 1
	  	}
		timer start named_timer $keepAliveTime KEEP_ALIVE_TIMER
		fsm setstate NEWCALLMSG
	}
}

proc act_GotDest { } {
	global optionSelected
	global queueMessage
	global queueID
	global keepAliveTime
	global KATIMER
	global PARAM1
	global CLI
	global playMusicFlag
	global callCloseFlag
	global svcUnavlbl
	global AATIMER
	global dialByExtension
	global retryMenuFlag
	global liveMusicFeed
	global optionIndex
	global retryDigitCollect
	global menuRetry
	# added for MLPP
	global isMLPPcode
	global ivr_precedence_index

	set AATIMER(getDestTime) [clock seconds]
	if { $CLI(number-of-hunt-grps) == 1 } {
		set AATIMER(curTime) [clock seconds]
	}
	set status [infotag get evt_status]
	set retryDigitCollect 0

	if {$status == "cd_005"} {
		set KATIMER(keepTime) [clock seconds]
		set optionSelected [infotag get evt_dcdigits]
		puts ">>>>>>>>>>>>> return from infotag get evt_dcdigits is : $optionSelected <<<<<<<<<<<<<<<<<<<<<<<<<"
		if {$optionSelected == $dialByExtension} {
			puts -nonewline "TCL AA: +++ Collect Extension Digits +++"
			set retryDigitCollect 1
			leg collectdigits leg_incoming PARAM1
			media play leg_incoming _bacd_enter_dest.au
			fsm setstate CALLTOEXTENSION
		} else {
			switch -exact $optionSelected {
				{#} {
					act_RetryMenu
				}
				{0} {
					act_GotDestNoOption
				}
				default {
					set playMusicFlag 1
					set retryMenuFlag 0
					set queueMessage(optionIDX) [expr $optionIndex + $optionSelected]
					set queueMessage(callState) CALL_NEW
					set queueMessage(keepTime) $KATIMER(keepTime)

					# added for MLPP
					if {$isMLPPcode == 1} {
						set queueMessage(Precedence) [get_precedence_info $ivr_precedence_index]
					}
					# added for MLPP

					set rval [sendmsg $queueID -p queueMessage]
					if { $rval == "unavailable" } {
						media play leg_incoming _bacd_disconnect.au
						set callCloseFlag 1
						set svcUnavlbl 1
					} else {
					##	media play leg_incoming _bacd_music_on_hold.au
						set liveMusicFeed 1
						media play leg_incoming moh:livemoh

						timer start named_timer $keepAliveTime KEEP_ALIVE_TIMER
						timer start named_timer $CLI(second-greeting-time) SECOND_GREETING_TIMER
						fsm setstate NEWCALLMSG
					}
				}
			}
		}
   	} elseif { ($status == "cd_001") || ($status == "cd_002") } {
		puts -nonewline "TCL AA: +++ No option selected +++"
		if { $CLI(menu-timeout) != "NONE" } {
			if { $menuRetry < $CLI(menu-timeout) } {
				set retryDigitCollect 1
				act_RetryMenu
				incr menuRetry
			} else {
				media play leg_incoming _bacd_xferto_operator.au
				fsm setstate OPTIONSELECTED
			}
		} else {
			set retryDigitCollect 1
			act_RetryMenu
		}
        } elseif { $status == "cd_010" } {
                log "TCL AA: +++ Enable DTMF Relay in dialpeer +++"
                media play leg_incoming _bacd_xferto_operator.au
                fsm setstate OPTIONSELECTED
	} else {
		fsm setstate same_state
		set retryDigitCollect 1
		act_RetryMenu
	}
}

proc act_RetryMenu { } {
	global PARAM
	global invalidHuntGrp
	global invalidExtension
	global retryMenuFlag
	global retryDigitCollect

	timer stop named_timer KEEP_ALIVE_TIMER
	timer stop named_timer SECOND_GREETING_TIMER
	set retryMenuFlag 1
	set retryDigitCollect 1
	leg collectdigits leg_incoming PARAM

	if {$invalidHuntGrp == 1} {
		media play leg_incoming _bacd_invalidoption.au %s500 _bacd_options_menu.au
		set invalidHuntGrp 0
	} elseif {$invalidExtension == 1} {
		media play leg_incoming _bacd_invalidoption.au %s500 _bacd_options_menu.au
		set invalidExtension 0
	} else {
		media play leg_incoming _bacd_options_menu.au
	}
	fsm setstate GETDEST
}

proc act_EvMediaDone { } {
	global callCloseFlag
	global playMusicFlag
	global retryMenuFlag
	global liveMusicFeed
	global legDisconnectTimer
	global retryDigitCollect
	global isMLPPcode
	global queueMessage

	if { $callCloseFlag == 1} {
		# modified for MLPP,CSCcu3460
                if {$isMLPPcode == 1} {
                        act_Cleanup $queueMessage(Precedence)
                } else {
                        # if not MLPP code
                        act_Cleanup
                }
	} elseif { $playMusicFlag == 1} {
		set mediaStatus [infotag get evt_status]
		puts -nonewline "TCL AA: -- MEDIA STATUS = $mediaStatus --"
		if { $mediaStatus == "ms_001"} {
			puts -nonewline "TCL AA: -- ERROR: Unable to play prompt; File not found --"
			set liveMusicFeed 0
		}
		if {($retryMenuFlag == 0) && ($liveMusicFeed == 1)} {
			media play leg_incoming moh:livemoh
			puts -nonewline "TCL AA: +++ Playing MOH Livefeed +++"
		} elseif {($retryMenuFlag == 0) && ($liveMusicFeed == 0)} {
			media play leg_incoming _bacd_music_on_hold.au
			puts -nonewline "TCL AA: +++ Playing MOH +++"
		} else {
			if {$retryDigitCollect == 0} {
				puts -nonewline "TCL AA: -- Disconnect Leg Timer Started --"
				puts -nonewline "TCL AA: -- Leg will be disconnected in $legDisconnectTimer Seconds --"
				timer start leg_timer $legDisconnectTimer leg_incoming
				fsm setstate CALLDISCONNECT
			}
		}
	} else {
		if {$retryDigitCollect == 0} {
			puts -nonewline "TCL AA: -- Disconnect Leg Timer Started --"
			puts -nonewline "TCL AA: -- Leg will be disconnected in $legDisconnectTimer Seconds --"
			timer start leg_timer $legDisconnectTimer leg_incoming
			fsm setstate CALLDISCONNECT
		}
	}
}

proc act_HandleMessage { } {
	global optionSelected
	global callInfo
	global CLI
	global queueID
	global KATIMER
	global callCloseFlag
	global invalidHuntGrp
	global voiceMailDN
	global vmHandoff
	global vmStatFlag
	global maxVMRetry
	global AATIMER
	global svcUnavlbl
	global vmSetupFlag
	global destHunt
	global dropThroMode
	global dropThroFlag
	global legDisconnectTimer
	global dropAgtFlag
	global retryMenuFlag
	global liveMusicFeed
	global isnName
	global isnInvokedFlag
	global isnTimeout
	global callAbandon
	global queueOverflowExtension
	global commandSetup
	global commandHandle
	global returnSetup
	global returnCode

	# added for MLPP
	global isMLPPcode
	global service_domain_index
	global mlpp_precedence_index
	global ivr_precedence_index
	global queueIdx

	set AATIMER(retTime) [clock seconds]
	set retryLimit [expr $AATIMER(retTime) - $AATIMER(curTime)]
	set msgFromService [infotag get evt_msg_source]
	infotag get evt_msg msgArray
	if { $retryLimit < $CLI(max-time-call-retry) } {
		if {([info exists msgArray(callState)] == 1) || ([info exists msgArray(optionIDX)] == 1)} {
			set KATIMER(keepTime) [clock seconds]
			switch -exact $msgArray(callState) {
				CALL_HUNT {
					set queueIdx $msgArray(Qidx)

					if {$isMLPPcode == 1} {
					# added for MLPP
						set callInfo(mlppServiceDomain) [get_precedence_info $service_domain_index]
						set callInfo(mlppPrecedenceLevel) [get_precedence_info $mlpp_precedence_index]
					}

					set destHunt $msgArray(optionIDX)
					puts -nonewline "TCL AA: >>> Destination Huntgroup = $msgArray(optionIDX) <<<"
					set callInfo(displayInfo) [infotag get leg_display_info leg_incoming]
					set callInfo(redirectNum) [infotag get leg_rdn]
					if {$dropThroMode == 1} {
						set dropThroFlag 1
						set dropAgtFlag 1
						leg setup $destHunt callInfo leg_incoming
					} else {
						set dropThroFlag 0
						# - Fix for CSCsz20368
						unset commandSetup
						leg setup $destHunt callInfo -l leg_incoming
						set commandSetup [infotag get last_command_handle]
					}
					set vmSetupFlag 0
					set queueMessage(optionIDX) $optionSelected
					set queueMessage(callState) CALL_PROGRESS
					set queueMessage(keepTime) $KATIMER(keepTime)

					# added for MLPP
					if {$isMLPPcode == 1} {
						set queueMessage(Precedence) [get_precedence_info $ivr_precedence_index]
					}
					# added for MLPP

					set rval [sendmsg $queueID -p queueMessage]
					if { $rval == "unavailable" } {
						media play leg_incoming _bacd_disconnect.au
						set callCloseFlag 1
						set svcUnavlbl 1
					} else {
						fsm setstate PLACECALL
					}
					timer start named_timer $CLI(call-retry-timer) CALL_RETRY_TIMER
				}
				CALL_RETRY {
					set dropThroFlag 0
					set destHunt $msgArray(optionIDX)
					set queueIdx $msgArray(Qidx)
					puts -nonewline "TCL AA: >> CALL_RETRY <<"
					# added for MLPP
					if {$isMLPPcode == 1} {
						set callInfo(mlppServiceDomain) [get_precedence_info $service_domain_index]
		                   		set callInfo(mlppPrecedenceLevel) [get_precedence_info $mlpp_precedence_index]
					}
					# added for MLPP
					# - Fix for CSCsz20368
					unset commandSetup
					set callInfo(displayInfo) [infotag get leg_display_info leg_incoming]
					leg setup $destHunt callInfo -l leg_incoming
					set commandSetup [infotag get last_command_handle]
					set vmSetupFlag 0
					set queueMessage(optionIDX) $optionSelected
					set queueMessage(callState) CALL_RETRY_PROGRESS
					set queueMessage(keepTime) $KATIMER(keepTime)
					# added for MLPP
					if {$isMLPPcode == 1} {
						set queueMessage(Precedence) [get_precedence_info $ivr_precedence_index]
					}
					# added for MLPP

					set rval [sendmsg $queueID -p queueMessage]
					if { $rval == "unavailable" } {
						media play leg_incoming _bacd_disconnect.au
						set callCloseFlag 1
						set svcUnavlbl 1
					} else {
						fsm setstate PLACECALL
					}
				}
				CALL_HOLD {
					set queueIdx $msgArray(Qidx)
					set dropThroFlag 0
					if { $dropAgtFlag == 0} {
						set liveMusicFeed 1
						set retryMenuFlag 0

						# play_q_position $queueIdx
						media play leg_incoming _bacd_allagentsbusy.au
						
						timer start named_timer $CLI(second-greeting-time) SECOND_GREETING_TIMER
						set dropAgtFlag 1
					}
					timer start named_timer $CLI(call-retry-timer) CALL_RETRY_TIMER
					fsm setstate CALLHOLD
				}
				NO_HUNT_GROUP {
					puts -nonewline "TCL AA: +++ Invalid option selected +++"
					set invalidHuntGrp 1
					act_RetryMenu
				}
				CALL_NAGT {
					set queueIdx $msgArray(Qidx)

					if {$isnInvokedFlag == 1} {
						set AATIMER(nagtTime) [clock seconds]
						set handOffTime [expr $AATIMER(nagtTime) - $AATIMER(curTime)]
						if {$handOffTime > $isnTimeout} {
							set callAbandon 1
							puts -nonewline "TCL AA: >>> ISN Timeout, Handing off to ISN Application <<<"
							timer stop named_timer SECOND_GREETING_TIMER
							timer stop named_timer CALL_RETRY_TIMER
							if {$isnName == "NONE"} {
								puts -nonewline "TCL AA: -- ERROR: No ISN Application configured, Disconnecting the call --"
								act_Cleanup
							} else {
								handoff appl leg_incoming $isnName
								act_Cleanup
							}
						} else {
							timer start named_timer $CLI(call-retry-timer) CALL_RETRY_TIMER
							fsm setstate CALLHOLD
						}
					} elseif {$maxVMRetry < $CLI(max-time-vm-retry)} {
						puts -nonewline "TCL AA: >>> No Agents are available; Forwarding to Voice Mail <<<"
						set callInfo(redirectNum) $msgArray(optionIDX)
						set callInfo(redirectCount) 1
						set dropThroFlag 0
						if { $dropAgtFlag == 0} {
							set liveMusicFeed 1
							set retryMenuFlag 0

							# play_q_position $queueIdx
							# media play leg_incoming _bacd_allagentsbusy.au
							timer start named_timer $CLI(second-greeting-time) SECOND_GREETING_TIMER
							set dropAgtFlag 1
						}

						# added for MLPP
						if {$isMLPPcode == 1} {
							set callInfo(mlppServiceDomain) [get_precedence_info $service_domain_index]
							set callInfo(mlppPrecedenceLevel) [get_precedence_info $mlpp_precedence_index]
						}

						set callInfo(guid) [infotag get leg_incoming_guid]
						puts -nonewline "TCL AA: >>> Incoming Leg GUID = [infotag get leg_incoming_guid] <<<"
						set vmSetupFlag 1
						if {$vmStatFlag == 0} {
							set queueMessage(vmStat) $vmStatFlag
							set vmStatFlag 1
						}
						set queueMessage(optionIDX) $optionSelected
						set queueMessage(callState) CALL_VM
						set queueMessage(keepTime) $KATIMER(keepTime)
						# added for MLPP
						if {$isMLPPcode == 1} {
							set queueMessage(Precedence) [get_precedence_info $ivr_precedence_index]
						}
						# added for MLPP

						set rval [sendmsg $queueID -p queueMessage]
						if { $rval == "unavailable" } {
							media play leg_incoming _bacd_disconnect.au
							set callCloseFlag 1
							set svcUnavlbl 1
						} else {
							if { $vmHandoff } {
							    puts -nonewline "TCL AA: >>> No Agents Handoff to voice mail DN <<<"
							    timer stop named_timer SECOND_GREETING_TIMER
							    timer stop named_timer CALL_RETRY_TIMER
							    timer stop named_timer KEEP_ALIVE_TIMER
							    set callAbandon 1
							    media stop leg_incoming
							    if {$commandSetup != 0} {
							       set returnSetup [command terminate $commandSetup]
							    }
							    if { $returnSetup != 0 } {
							       fsm setstate VM_TERMINATESETUP
							       return
							     }
							     if {$commandHandle != 0} {			
							        puts ">>> commandHandle = $commandHandle <<<<<<<"			                
							        returnCode [command terminate $commandHandle]
							        puts ">>>>> return code = $returnCode <<<<<"              
							     }
							     if { $returnCode == 0 } {
							        fsm setstate VM_TERMINATESETUP
							        return
							     }
							     handoff appl leg_incoming default "DESTINATION=$voiceMailDN"
							     act_Cleanup
							} else {
							    leg setup $voiceMailDN callInfo -l leg_incoming
							    fsm setstate PLACECALL
							    incr maxVMRetry
							    puts -nonewline "TCL AA: >>> No of attempts to voice mail = $maxVMRetry <<<"			        
							}
						}	 					
					} else {
						puts -nonewline "TCL AA: >> Voice mail timeout, Disconnecting the call <<"
						timer stop named_timer SECOND_GREETING_TIMER
						timer stop named_timer CALL_RETRY_TIMER
						media play leg_incoming _bacd_disconnect.au
						set callCloseFlag 1
					}
				}
				CALL_REJECT {
					if {$queueOverflowExtension == "NONE"} {
						puts -nonewline "TCL AA: +++ Queue is Full; Call Rejected +++"
						timer stop named_timer SECOND_GREETING_TIMER
						timer stop named_timer CALL_RETRY_TIMER
						timer stop named_timer KEEP_ALIVE_TIMER
						set callCloseFlag 1
						playtone leg_incoming tn_busy
						timer start leg_timer $legDisconnectTimer leg_incoming
						fsm setstate CALLDISCONNECT
					} else {
						puts -nonewline "TCL AA: +++ Queue is Full; Sending call to queue-overflow-extension +++"
						timer stop named_timer SECOND_GREETING_TIMER
						timer stop named_timer CALL_RETRY_TIMER
						timer stop named_timer KEEP_ALIVE_TIMER
						fsm setstate EXITQUEUE
						handoff callappl leg_incoming default "DESTINATION=$queueOverflowExtension"
					}
				}
				default {
					act_Cleanup
				}
			}
		}
	} else {
		if {$isnInvokedFlag == 1} {
			set callAbandon 1
			puts -nonewline "TCL AA: >>> Maximum Retry Limit Reached, Handing off to ISN Application <<<"
			timer stop named_timer SECOND_GREETING_TIMER
			timer stop named_timer CALL_RETRY_TIMER
			if {$isnName == "NONE"} {
				puts -nonewline "TCL AA: -- ERROR: No ISN Application configured, Disconnecting the call --"
				act_Cleanup
			} else {
				handoff appl leg_incoming $isnName
				act_Cleanup
			}
		} elseif {$maxVMRetry < $CLI(max-time-vm-retry)} {
			puts -nonewline "TCL AA: >>> Maximum Retry Limit Reached, Forwarding to Voice Mail <<<"
			set dropThroFlag 0
			set callInfo(redirectNum) $destHunt
			set callInfo(redirectCount) 1
			# added for MLPP
			if {$isMLPPcode == 1} {
				set callInfo(mlppServiceDomain) [get_precedence_info $service_domain_index]
				set callInfo(mlppPrecedenceLevel) [get_precedence_info $mlpp_precedence_index]
			}
			# added for MLPP
			set callInfo(guid) [infotag get leg_incoming_guid]
			puts -nonewline "TCL AA: >>> Incoming Leg GUID = [infotag get leg_incoming_guid] <<<"			
			set vmSetupFlag 1
			if {$vmStatFlag == 0} {
				set queueMessage(vmStat) $vmStatFlag
				set vmStatFlag 1
			}
			set queueMessage(optionIDX) $optionSelected
			set queueMessage(callState) CALL_VM
			set queueMessage(keepTime) $KATIMER(keepTime)
			# added for MLPP
			if {$isMLPPcode == 1} {
				set queueMessage(Precedence) [get_precedence_info $ivr_precedence_index]
			}
			# added for MLPP
			set rval [sendmsg $queueID -p queueMessage]
			if { $rval == "unavailable" } {
				media play leg_incoming _bacd_disconnect.au
				set svcUnavlbl 1
				set callCloseFlag 1
			} else {
			    if { $vmHandoff } {
			        puts -nonewline "TCL AA: >>> Max Retry Handoff to voice mail DN <<<"
			        timer stop named_timer SECOND_GREETING_TIMER
			        timer stop named_timer CALL_RETRY_TIMER
			        timer stop named_timer KEEP_ALIVE_TIMER
			        set callAbandon 1
			        media stop leg_incoming
			        if {$commandSetup != 0} {
			           set returnSetup [command terminate $commandSetup]
			        }
			        if { $returnSetup != 0 } {
			           fsm setstate VM_TERMINATESETUP
			           return
			        }
			        if {$commandHandle != 0} {			
			           puts ">>> commandHandle = $commandHandle <<<<<<<"			                
			           set returnCode [command terminate $commandHandle]
			           puts ">>>>> return code = $returnCode <<<<<"              
			        }
			        if { $returnCode == 0 } {
			           fsm setstate VM_TERMINATESETUP
			           return
			        }
			        handoff appl leg_incoming default "DESTINATION=$voiceMailDN"
			        act_Cleanup
			    } else {
			        leg setup $voiceMailDN callInfo -l leg_incoming
			        fsm setstate PLACECALL
			        incr maxVMRetry
			        puts -nonewline "TCL AA: >>> No of attempts to voice mail = $maxVMRetry <<<"			        
			    }
			}
		} else {
			puts -nonewline "TCL AA: >> Voice mail timeout, Disconnecting the call <<"
			media play leg_incoming _bacd_disconnect.au
			timer stop named_timer SECOND_GREETING_TIMER
			timer stop named_timer CALL_RETRY_TIMER
			set callCloseFlag 1
		}
	}
}

proc act_CallSetupDone { } {
	global busyPrompt
	global optionSelected
	global queueID
	global CLI
	global KATIMER
	global callCloseFlag
	global svcUnavlbl
	global dropThroFlag
	global liveMusicFeed
	global dropAgtFlag
	global PARAM2
	global queueExitFlag
	global scndGreCnt
	global commandHandle
	global commandSetup
	# added for MLPP
	global isMLPPcode
	global ivr_precedence_index
	global queueIdx

	set status [infotag get evt_status]
	set KATIMER(keepTime) [clock seconds]
	puts "\n proc act_CallSetupDone"
	puts "\n IP IVR Leg Setup Status = $status"
	switch -exact $status {
		ls_000 {
			puts -nonewline "TCL AA: >> Call answered by the agent; Call Connected <<"
			if {$dropThroFlag == 1} {
                  act_HandoffLegs
			} else {
				fsm setstate OUTGOINGLEGACTIVE
				media stop leg_incoming
				connection create leg_incoming leg_outgoing
			}
		}
		ls_002 {
			puts -nonewline "TCL AA: >> Agent did not answer; Received Call NOAN <<"
			set commandSetup 0
			set queueMessage(optionIDX) $optionSelected
			set queueMessage(callState) CALL_NOAN
			set queueMessage(keepTime) $KATIMER(keepTime)
			# added for MLPP
			if {$isMLPPcode == 1} {
				set queueMessage(Precedence) [get_precedence_info $ivr_precedence_index]
			}
			# added for MLPP

			set rval [sendmsg $queueID -p queueMessage]
			if { $rval == "unavailable" } {
				media play leg_incoming _bacd_disconnect.au
				set svcUnavlbl 1
				set callCloseFlag 1
			} else {
				if {$dropThroFlag == 1} {
					set retryMenuFlag 0
					set liveMusicFeed 1
					set dropAgtFlag 1
					if { ($scndGreCnt == 0) || ($queueExitFlag == 1)} {
						leg collectdigits leg_incoming PARAM2
						set commandHandle [infotag get last_command_handle]
						set queueExitFlag 0
					}
					incr scndGreCnt

					# play_q_position $queueIdx
					media play leg_incoming _bacd_allagentsbusy.au
					timer start named_timer $CLI(second-greeting-time) SECOND_GREETING_TIMER
				}
				timer start named_timer $CLI(call-retry-timer) CALL_RETRY_TIMER
				fsm setstate CALLHOLD
			}
		}
		ls_004 {
			puts -nonewline "TCL AA: >>> Invalid Number, Forwarding to Voice Mail <<<"
			handoff appl leg_incoming default "DESTINATION=$voiceMailDN"
			call close
		}
		ls_007 {
			puts -nonewline "TCL AA: >> Agent Busy <<"
			set commandSetup 0
			set queueMessage(optionIDX) $optionSelected
			set queueMessage(callState) CALL_BUSY
			set queueMessage(keepTime) $KATIMER(keepTime)
			# added for MLPP
			if {$isMLPPcode == 1} {
				set queueMessage(Precedence) [get_precedence_info $ivr_precedence_index]
			}
			# added for MLPP

			set rval [sendmsg $queueID -p queueMessage]
			if { $rval == "unavailable" } {
				media play leg_incoming _bacd_disconnect.au
				set svcUnavlbl 1
				set callCloseFlag 1
			} else {
				if {$dropThroFlag == 1} {
					set retryMenuFlag 0
					set liveMusicFeed 1
					set dropAgtFlag 1
					if { ($scndGreCnt == 0) || ($queueExitFlag == 1)} {
						leg collectdigits leg_incoming PARAM2
						set commandHandle [infotag get last_command_handle]
						set queueExitFlag 0
					}
					incr scndGreCnt

					# play_q_position $queueIdx
					media play leg_incoming _bacd_allagentsbusy.au
					timer start named_timer $CLI(second-greeting-time) SECOND_GREETING_TIMER
				}
				timer start named_timer $CLI(call-retry-timer) CALL_RETRY_TIMER
				fsm setstate CALLHOLD
			}
		}
		default {
			puts -nonewline "TCL AA: +++ Received signal other than busy or noan +++"
			set commandSetup 0
			set queueMessage(optionIDX) $optionSelected
			set queueMessage(callState) CALL_TEMP_FAILURE
			set queueMessage(keepTime) $KATIMER(keepTime)
			# added for MLPP
			if {$isMLPPcode == 1} {
				set queueMessage(Precedence) [get_precedence_info $ivr_precedence_index]
			}
			# added for MLPP

			set rval [sendmsg $queueID -p queueMessage]
			if { $rval == "unavailable" } {
				media play leg_incoming _bacd_disconnect.au
				set svcUnavlbl 1
				set callCloseFlag 1
			} else {
				if {$dropThroFlag == 1} {
					set retryMenuFlag 0
					set liveMusicFeed 1
					set dropAgtFlag 1

					# play_q_position $queueIdx
					media play leg_incoming _bacd_allagentsbusy.au
					timer start named_timer $CLI(second-greeting-time) SECOND_GREETING_TIMER
				}
				timer start named_timer $CLI(call-retry-timer) CALL_RETRY_TIMER
				fsm setstate CALLHOLD
			}
		}
	}
}

proc act_CallOnHold { } {
	global optionSelected
	global queueID
	global KATIMER
	global keepAliveTime
	global CLI
	global callCloseFlag
	global svcUnavlbl
	global retryMenuFlag
	global liveMusicFeed
	global PARAM2
	global queueExitFlag
	global scndGreCnt
	global commandHandle
	# added for MLPP
	global isMLPPcode
	global ivr_precedence_index
	global queueIdx
	global dropAgtFlag

	set retryTimer [infotag get evt_timer_name]
	set KATIMER(keepTime) [clock seconds]
	if {$retryTimer == "CALL_RETRY_TIMER"} {
		set queueMessage(optionIDX) $optionSelected
		set queueMessage(callState) CALL_RETRY
		set queueMessage(keepTime) $KATIMER(keepTime)

		# added for MLPP
		if {$isMLPPcode == 1} {
		   set current_precedence [get_precedence_info $ivr_precedence_index]
		   if {$current_precedence != ""} {
		      set queueMessage(Precedence) $current_precedence
		   } else {
		      set queueMessage(Precedence) 5
		      puts -nonewline "TCL AA: +++ Leg doesn't exist when CALL_RETRY_TIMER expire +++"
		   }
		}
		# added for MLPP

		set rval [sendmsg $queueID -p queueMessage]
		if { $rval == "unavailable" } {
			set legID [string trim [infotag get leg_incoming]]
			if {$legID != ""} {
			   media play leg_incoming _bacd_disconnect.au
			}
			set svcUnavlbl 1
			set callCloseFlag 1
		} else {
			timer start named_timer $CLI(call-retry-timer) CALL_RETRY_TIMER
		}
	} elseif {$retryTimer == "SECOND_GREETING_TIMER"} {
		if { ($scndGreCnt == 0) || ($queueExitFlag == 1)} {
		    set legID [string trim [infotag get leg_incoming]]
		    if {$legID != ""} {
		 	 leg collectdigits leg_incoming PARAM2
		    } else {
		      puts -nonewline "TCL AA: +++ Leg doesn't exist when SECOND_GREETING_TIMER expire +++"
		 
		    }
		  set commandHandle [infotag get last_command_handle]
		  set queueExitFlag 0
		}
		incr scndGreCnt
		set legID [string trim [infotag get leg_incoming]]

	        if {$legID != ""} {
			   # set flag so all agent busy won't play again when receive CALL_HOLD from queue
			   set dropAgtFlag 1
			   media play leg_incoming _bacd_allagentsbusy.au
			   # play_q_position $queueIdx
	        }

		set retryMenuFlag 0
		set liveMusicFeed 1
		puts -nonewline "TCL AA: +++ COLLECTING DIGITS TO QUIT QUEUE +++"
		puts -nonewline "TCL AA: +++ Now playing second greeting prompt +++"
		timer start named_timer $CLI(second-greeting-time) SECOND_GREETING_TIMER
	} elseif {$retryTimer == "KEEP_ALIVE_TIMER"} {
		if { $optionSelected != 0} {
			set queueMessage(optionIDX) $optionSelected
			set queueMessage(callState) HELLO
			set queueMessage(keepTime) $KATIMER(keepTime)

			# added for MLPP
			if {$isMLPPcode == 1} {
				set current_precedence [get_precedence_info $ivr_precedence_index]
				if {$current_precedence != ""} {
					set queueMessage(Precedence) $current_precedence
				} else {
				    set queueMessage(Precedence) 5
			  		puts -nonewline "TCL AA: +++ Leg doesn't exist when KEEP_ALIVE_TIMER expire +++"
		   		}
			}
		   # added for MLPP
			set rval [sendmsg $queueID -p queueMessage]
			if { $rval == "unavailable" } {
				set legID [string trim [infotag get leg_incoming]]
			    if {$legID != ""} {
				   media play leg_incoming _bacd_disconnect.au
			    }
				set svcUnavlbl 1
				set callCloseFlag 1
			} else {
				timer start named_timer $keepAliveTime KEEP_ALIVE_TIMER
			}
		}
	}
}

proc act_Exit2VM { } {
    global commandSetup
    global returnSetup
    global commandHandle
    global returnCode
    global voiceMailDN
    
    puts "TCL AA: +++ act_Exit2VM +++"
    if {$commandSetup != 0} {
         puts "TCL AA: +++ act_Exit2VM commandSetup != 0 +++"
         set returnSetup [command terminate $commandSetup]
          puts ">>>>> returnSetup = $returnSetup <<<<<" 
    }
    if { $returnSetup != 0 } {
        puts "TCL AA: +++ act_Exit2VM returnSetup!= 0 +++"
        fsm setstate VM_TERMINATESETUP
	return
    }
    
    if {$commandHandle != 0} {
       puts ">>> commandHandle = $commandHandle <<<<<<<"			                
       set returnCode [command terminate $commandHandle]
       puts ">>>>> return code = $returnCode <<<<<"              
    } 
    
    if { $returnCode == 0 } {
       fsm setstate VM_TERMINATESETUP
       return
    }
	                
    handoff appl leg_incoming default "DESTINATION=$voiceMailDN"
    act_Cleanup
        
}
proc act_ExitQueue { } {
	global queueExitOption1
	global queueExitOption2
	global queueExitOption3
	global queueExitExtension1
	global queueExitExtension2
	global queueExitExtension3
	global callAbandon
	global queueExitFlag
	global PARAM2
	global scndGreCnt
	global commandHandle
	global commandSetup
        global returnSetup
	# added for MLPP
	global isMLPPcode
	global ivr_precedence_index
	global exitQ_cleanup
	global queueIdx

	set queueExitFlag 1
	set exitQ_cleanup 0
	set status [infotag get evt_status]
	puts -nonewline "TCL AA: +++ DIGITS TO QUIT QUEUE STATUS = $status +++"
	# added for MLPP
	# This fixed CSCcu3460
	 if {$isMLPPcode == 1} {
	    set queueMessage(Precedence) [get_precedence_info $ivr_precedence_index]
	 }
	# added for MLPP

        # - Fix for CSCsz20368
         if {$commandSetup != 0} {
                set returnSetup [command terminate $commandSetup]
	 }
          if { $returnSetup != 0 } {
         	 fsm setstate TERMINATESETUP
	  	 return
	  }

	if {$status == "cd_005"} {
		set exitOption [infotag get evt_dcdigits]
		if { $exitOption == $queueExitOption1 } {
			timer stop named_timer SECOND_GREETING_TIMER
			timer stop named_timer CALL_RETRY_TIMER
			timer stop named_timer KEEP_ALIVE_TIMER
			set callAbandon 1
			fsm setstate EXITQUEUE
			handoff callappl leg_incoming default "DESTINATION=$queueExitExtension1"
			set exitQ_cleanup 1
			# modified for MLPP,CSCcu3460
			if {$isMLPPcode == 1} {
				act_Cleanup $queueMessage(Precedence)
			} else {
				# if not MLPP code
		   		act_Cleanup
			}
		} elseif { $exitOption == $queueExitOption2 } {
			timer stop named_timer SECOND_GREETING_TIMER
			timer stop named_timer CALL_RETRY_TIMER
			timer stop named_timer KEEP_ALIVE_TIMER
			set callAbandon 1
			fsm setstate EXITQUEUE
			handoff callappl leg_incoming default "DESTINATION=$queueExitExtension2"
			set exitQ_cleanup 1
			# modified for MLPP,CSCcu3460
			if {$isMLPPcode == 1} {
				act_Cleanup $queueMessage(Precedence)
			} else {
				# if not MLPP code
		   		act_Cleanup
			}
		} elseif { $exitOption == $queueExitOption3 } {
			timer stop named_timer SECOND_GREETING_TIMER
			timer stop named_timer CALL_RETRY_TIMER
			timer stop named_timer KEEP_ALIVE_TIMER
			set callAbandon 1
			fsm setstate EXITQUEUE
			handoff callappl leg_incoming default "DESTINATION=$queueExitExtension3"
			set exitQ_cleanup 1
			# modified for MLPP,CSCcu3460
			if {$isMLPPcode == 1} {
				act_Cleanup $queueMessage(Precedence)
			} else {
				# if not MLPP code
		   		act_Cleanup
			}
		} else {
			incr scndGreCnt
			if { ($scndGreCnt == 0) || ($queueExitFlag == 1)} {
				leg collectdigits leg_incoming PARAM2
				set commandHandle [infotag get last_command_handle]
				set queueExitFlag 0
			}
			media play leg_incoming _bacd_invalidoption.au %s500 _bacd_allagentsbusy.au
			fsm setstate same_state
		}
	} elseif { ($status == "cd_001") || ($status == "cd_002")} {
		puts -nonewline "TCL AA: +++ DIGIT COLLECT TO QUIT TIMED OUT +++"
		fsm setstate same_state
	}
}

proc act_HandoffReturned { } {
        global isMLPPcode
        global queueMessage

        set handoffStatus [infotag get evt_handoff_string]
        puts -nonewline "TCL AA: +++ Handoff return is $handoffStatus"
        if {($handoffStatus == "RESULT=di_016") || ($handoffStatus == "" )} {
		# modified for MLPP,CSCcu3460
                call close
                return
        } else {
		set callCloseFlag 1
                media play leg_incoming _bacd_disconnect.au
        }

}

proc act_HandoffToExtension { } {
	global maxExtensionLen
	global invalidExtension

	set status [infotag get evt_status]
	if {$status == "cd_004"} {
		set destExtension [infotag get evt_dcdigits]
		set destExtLen [string length $destExtension]
		set extLength [expr $maxExtensionLen - $destExtLen]
		if {($maxExtensionLen > 0) && ($extLength >= 0)} {
			handoff appl leg_incoming default "DESTINATION=$destExtension"
		} elseif {$maxExtensionLen == 0} {
			handoff appl leg_incoming default "DESTINATION=$destExtension"
		} elseif {($maxExtensionLen > 0) && ($extLength < 0)} {
			set invalidExtension 1
			fsm setstate same_state
			act_RetryMenu
		} else {
			set invalidExtension 1
			fsm setstate same_state
			act_RetryMenu
		}
   	} elseif { ($status == "cd_001") || ($status == "cd_002") } {
		puts -nonewline "TCL AA: +++ No Extension number entered +++"
		act_RetryMenu
	} else {
		set invalidExtension 1
		fsm setstate same_state
		act_RetryMenu
	}
}

proc act_HandoffLegs { } {
	global optionSelected
	global queueID
	global AATIMER
	global KATIMER
	global callAbandon
	global vmStatFlag
	global callCloseFlag
	global svcUnavlbl
	global vmSetupFlag
	global CLI
	global answerTime
	global commandHandle
	global returnCode
	# added for MLPP
	global isMLPPcode
	global ivr_precedence_index

	if {$commandHandle != 0} {
		set returnCode [command terminate $commandHandle]
                puts "TCL AA: command terminate returning $returnCode"
	}
	if { $returnCode == 0 } {
		fsm setstate COMMANDTERMINATE
		return
	}
	set AATIMER(ansTime) [clock seconds]
	if { $CLI(number-of-hunt-grps) == 1 } {
		set answerTime [expr $AATIMER(ansTime) - $AATIMER(curTime)]
	} else {
		set answerTime [expr $AATIMER(ansTime) - $AATIMER(getDestTime)]
	}
	if { $answerTime > $CLI(max-time-call-retry)} {
		puts -nonewline "TCL AA: -- Answer Time is $answerTime --"
	}
	set callAbandon 0
	if {($vmStatFlag == 1) && ($vmSetupFlag == 1)} {
		set queueMessage(vmStat) $vmStatFlag
	}
	set queueMessage(optionIDX) $optionSelected
	set queueMessage(callState) CALL_HANDOFF
	set queueMessage(ansTime) $answerTime
	set queueMessage(keepTime) $AATIMER(ansTime)
	# added for MLPP
	if {$isMLPPcode == 1} {
		set queueMessage(Precedence) [get_precedence_info $ivr_precedence_index]
	}
	# added for MLPP
	set rval [sendmsg $queueID -p queueMessage]
	if { $rval == "unavailable" } {
		media play leg_incoming _bacd_disconnect.au
		set svcUnavlbl 1
		set callCloseFlag 1
	} else {
		set legIN [infotag get leg_incoming]
		set legOUT [infotag get leg_outgoing]
		puts -nonewline "TCL AA: >>> Incoming LEG ID = $legIN; Outgoing LEG ID = $legOUT <<<"
		handoff appl leg_all default
		# modified for MLPP
		if {$isMLPPcode == 1} {
			act_Cleanup $queueMessage(Precedence)
		} else {
		# if not MLPP code
		   act_Cleanup
		}
	}
}

#Modified for MLPP -- after "handoff appl leg_all default" can not do "infotag get leg_precedence_info $legID" so passing pre-captured precedence
#otherwise business as usual



proc act_Cleanup { {PR ""}} {
	global optionSelected
	global queueID
	global callAbandon
	global AATIMER
	global KATIMER
	global svcUnavlbl
	global CLI
	# added for MLPP
	global isMLPPcode
   	global ivr_precedence_index
        global exitQ_cleanup

	if { ($optionSelected != 0) && ($callAbandon == 1) && ($svcUnavlbl == 0) } {
		set AATIMER(abandonTime) [clock seconds]
		if {$CLI(number-of-hunt-grps) == 1} {
			set abandonTime [expr $AATIMER(abandonTime) - $AATIMER(curTime)]
		} else {
			set abandonTime [expr $AATIMER(abandonTime) - $AATIMER(getDestTime)]
		}
		set queueMessage(optionIDX) $optionSelected
		set queueMessage(callState) CALL_HANGUP
		set queueMessage(abandonTime) $abandonTime
		set queueMessage(keepTime) $AATIMER(abandonTime)

		# added for MLPP
		if {$isMLPPcode == 1} {
			if {$PR != ""} {
				set queueMessage(Precedence) $PR
				# for special case in act_HandoffLegs
			} else {
				set queueMessage(Precedence) [get_precedence_info $ivr_precedence_index]
			}
		}
        # added for MLPP

		set rval [sendmsg $queueID -p queueMessage]
	} elseif {($optionSelected != 0) && ($callAbandon == 0) && ($svcUnavlbl == 0)} {
		set KATIMER(keepTime) [clock seconds]
		set queueMessage(optionIDX) $optionSelected
		set queueMessage(callState) CALL_HANGUP
		set queueMessage(keepTime) $KATIMER(keepTime)

		# added for MLPP
		if {$isMLPPcode == 1} {
			if {$PR != ""} {
				set queueMessage(Precedence) $PR
				# for special case in act_HandoffLegs
			} else {
				set queueMessage(Precedence) [get_precedence_info $ivr_precedence_index]
			}
		}
        # added for MLPP

		set rval [sendmsg $queueID -p queueMessage]
	}
	if {$exitQ_cleanup == 1} {
	    set exitQ_cleanup 0
	} else {
	   call close
	}
}



requiredversion 2.0
init
set initialized 0
#init_ConfigVars
#----------------------------------
#   State Machine
#----------------------------------
	set fsm(any_state,ev_disconnected)   "act_Cleanup  same_state"
	set fsm(CALL_INIT,ev_setup_indication) "act_Setup  GETDEST"
	set fsm(CALL_INIT,ev_setup_indication) "act_Setup  OPTIONSELECTED"
	set fsm(CALL_INIT,ev_handoff) "act_Handoff_Activity  GETDEST"
	set fsm(CALL_INIT,ev_handoff) "act_Handoff_Activity  OPTIONSELECTED"
	set fsm(OPTIONSELECTED,ev_media_done) "act_GotDestNoOption NEWCALLMSG"
	set fsm(GETDEST,ev_collectdigits_done) "act_GotDest NEWCALLMSG"
	set fsm(CALLTOEXTENSION,ev_collectdigits_done) "act_HandoffToExtension same_state"
	set fsm(NEWCALLMSG,ev_media_done) "act_EvMediaDone same_state"
	set fsm(NEWCALLMSG,ev_msg_indication) "act_HandleMessage PLACECALL"
	set fsm(NEWCALLMSG,ev_msg_indication) "act_HandleMessage CALLHOLD"
	set fsm(CALLHOLD,ev_named_timer) "act_CallOnHold NEWCALLMSG"
	set fsm(TERMINATESETUP,ev_setup_done) "act_ExitQueue same_state"
	set fsm(VM_TERMINATESETUP,ev_setup_done) "act_Exit2VM same_state"
	set fsm(VM_TERMINATESETUP,ev_collectdigits_done) "act_Exit2VM same_state"
	set fsm(any_state,ev_collectdigits_done) "act_ExitQueue same_state"
	set fsm(EXITQUEUE,ev_returned)  "act_HandoffReturned same_state"
	set fsm(COMMANDTERMINATE,ev_collectdigits_done) "act_HandoffLegs HANDOFF"
	set fsm(any_state,ev_media_done) "act_EvMediaDone same_state"
	set fsm(any_state,ev_named_timer) "act_CallOnHold same_state"
	set fsm(PLACECALL,ev_setup_done)   "act_CallSetupDone  OUTGOINGLEGACTIVE"
	set fsm(OUTGOINGLEGACTIVE,ev_create_done) "act_HandoffLegs HANDOFF"
	set fsm(CALLDISCONNECT,ev_disconnect_done) "act_Cleanup  same_state"
	set fsm(CALLDISCONNECT,ev_leg_timer) "act_Cleanup  same_state"

	fsm define fsm CALL_INIT
